/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.indexer;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.IPHPFunctionEntryValue;
import com.aptana.editor.php.internal.indexer.IndexPersistence;
import gnu.trove.set.hash.THashSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class FunctionPHPEntryValue
extends AbstractPHPEntryValue
implements IPHPFunctionEntryValue {
    private static final String[] NO_STRING_PARAMS = new String[0];
    private static final boolean[] NO_BOOLEAN_PARAMS = new boolean[0];
    private static final Object[] NO_OBJECT_PARAMS = new Object[0];
    private static final int[] NO_INT_PARAMS = new int[0];
    private boolean isMethod;
    private boolean isTraitMethod;
    private String[] parameterNames;
    private Object[] parameterTypes;
    private int[] parameterStartPositions;
    private boolean[] parameterMandatories;
    private Object returnTypes;

    public FunctionPHPEntryValue(int modifiers, boolean isMethod, int startPosition, String nameSpace) {
        super(modifiers, nameSpace);
        this.setStartOffset(startPosition);
        this.isMethod = isMethod;
    }

    public FunctionPHPEntryValue(int modifiers, boolean isMethod, Map<String, Set<Object>> parameters, int[] parameterStartPositions, boolean[] parameterMandatories, int startPosition, String nameSpace) {
        super(modifiers, nameSpace);
        if (parameters != null) {
            if (parameters.size() != 0) {
                if (parameterStartPositions == null || parameters.size() < parameterStartPositions.length) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)MessageFormat.format("Illegal parameter start positions: parameters = {0} while the parameterStartPositions = {1}. Check for duplicate arguments in your function declaration.", parameters, Arrays.toString(parameterStartPositions)), null);
                } else if (parameterStartPositions != null && parameters.size() > parameterStartPositions.length) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"An extra parameter is defined in the PHPDoc, but not in the function declaration.", null);
                }
            }
            this.parameterStartPositions = parameterStartPositions;
            if (parameterMandatories == null || parameters.size() != parameterMandatories.length) {
                boolean[] newMandatories;
                if (parameterMandatories == null) {
                    parameterMandatories = new boolean[parameters.size()];
                } else if (parameters.size() > parameterMandatories.length) {
                    newMandatories = new boolean[parameters.size()];
                    System.arraycopy(parameterMandatories, 0, newMandatories, 0, parameterMandatories.length);
                    parameterMandatories = newMandatories;
                } else {
                    newMandatories = new boolean[parameters.size()];
                    System.arraycopy(parameterMandatories, 0, newMandatories, 0, newMandatories.length);
                    parameterMandatories = newMandatories;
                }
            }
            this.parameterMandatories = parameterMandatories;
            this.parameterNames = new String[parameters.size()];
            this.parameterTypes = new Object[parameters.size()];
            int i = 0;
            for (Map.Entry<String, Set<Object>> entry : parameters.entrySet()) {
                this.parameterNames[i] = entry.getKey();
                Set<Object> types = entry.getValue();
                if (types != null && types.size() != 0) {
                    if (types.size() == 1) {
                        Object type;
                        this.parameterTypes[i] = type = types.iterator().next();
                    } else {
                        THashSet typesToSave = new THashSet(types.size());
                        typesToSave.addAll(types);
                        this.parameterTypes[i] = typesToSave;
                    }
                }
                ++i;
            }
        }
        this.setStartOffset(startPosition);
        this.isMethod = isMethod;
    }

    public FunctionPHPEntryValue(DataInputStream di) throws IOException {
        super(di);
        this.internalRead(di);
    }

    public void setReturnType(Object type) {
        this.returnTypes = type;
    }

    public void setReturnTypes(Set<Object> types) {
        if (types != null && types.size() != 0) {
            if (types.size() == 1) {
                this.setReturnType(types.iterator().next());
            } else {
                Object[] typesArray = new Object[types.size()];
                types.toArray(typesArray);
                this.returnTypes = typesArray;
            }
        }
    }

    public Set<Object> getReturnTypes() {
        if (this.returnTypes == null) {
            return Collections.emptySet();
        }
        if (this.returnTypes instanceof Object[]) {
            Object[] returnTypesArray = (Object[])this.returnTypes;
            THashSet result = new THashSet(returnTypesArray.length);
            int i = 0;
            while (i < returnTypesArray.length) {
                result.add(returnTypesArray[i]);
                ++i;
            }
            return result;
        }
        THashSet result = new THashSet(1);
        result.add(this.returnTypes);
        return result;
    }

    public boolean[] getMandatoryParams() {
        if (this.parameterMandatories == null) {
            return NO_BOOLEAN_PARAMS;
        }
        boolean[] toReturn = new boolean[this.parameterMandatories.length];
        System.arraycopy(this.parameterMandatories, 0, toReturn, 0, this.parameterMandatories.length);
        return toReturn;
    }

    public boolean isMethod() {
        return this.isMethod;
    }

    public boolean isTraitMethod() {
        return this.isTraitMethod;
    }

    public void setIsTraitMethod(boolean isTraitMethod) {
        this.isTraitMethod = isTraitMethod;
    }

    @Override
    public Map<String, Set<Object>> getParameters() {
        if (this.parameterNames != null) {
            LinkedHashMap<String, Set<Object>> result = new LinkedHashMap<String, Set<Object>>(this.parameterNames.length);
            int i = 0;
            while (i < this.parameterNames.length) {
                HashSet<Object> types = new HashSet<Object>();
                Object typeObj = this.parameterTypes[i];
                if (typeObj != null) {
                    if (typeObj instanceof Set) {
                        types.addAll((Set)typeObj);
                    } else {
                        types.add(typeObj);
                    }
                }
                result.put(this.parameterNames[i], types);
                ++i;
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isMethod ? 1231 : 1237);
        result = 31 * result + (this.isTraitMethod ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionPHPEntryValue other = (FunctionPHPEntryValue)obj;
        return this.isMethod == other.isMethod && this.isTraitMethod == other.isTraitMethod;
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public int[] getParameterStartPositions() {
        return this.parameterStartPositions;
    }

    @Override
    protected void internalWrite(DataOutputStream da) throws IOException {
        da.writeBoolean(this.isMethod);
        da.writeBoolean(this.isTraitMethod);
        IndexPersistence.writeType(this.returnTypes, da);
        int len = this.parameterNames == null ? 0 : this.parameterNames.length;
        da.writeInt(len);
        int a = 0;
        while (a < len) {
            da.writeUTF(this.parameterNames[a]);
            da.writeBoolean(this.parameterMandatories[a]);
            da.writeInt(this.parameterStartPositions[a]);
            IndexPersistence.writeType(this.parameterTypes[a], da);
            ++a;
        }
    }

    @Override
    protected void internalRead(DataInputStream di) throws IOException {
        this.isMethod = di.readBoolean();
        this.isTraitMethod = di.readBoolean();
        this.returnTypes = IndexPersistence.readType(di);
        int pc = di.readInt();
        if (pc > 0) {
            this.parameterNames = new String[pc];
            this.parameterMandatories = new boolean[pc];
            this.parameterTypes = new Object[pc];
            this.parameterStartPositions = new int[pc];
            int a = 0;
            while (a < pc) {
                this.parameterNames[a] = di.readUTF();
                this.parameterMandatories[a] = di.readBoolean();
                this.parameterStartPositions[a] = di.readInt();
                this.parameterTypes[a] = IndexPersistence.readType(di);
                ++a;
            }
        } else {
            this.parameterNames = NO_STRING_PARAMS;
            this.parameterMandatories = NO_BOOLEAN_PARAMS;
            this.parameterStartPositions = NO_INT_PARAMS;
            this.parameterTypes = NO_OBJECT_PARAMS;
        }
    }
}

